/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.ByteUtilities;
import java.io.UnsupportedEncodingException;

public class PIFspString {
    private int m_stringLength = 0;
    private String m_original = null;
    private byte[] m_rawBytes = null;
    private byte[] m_paddedBytes = null;
    private int m_padBytes = 0;
    private int m_rawLength = 0;
    private int m_paddedLength = 0;
    private String hexString = null;

    public PIFspString(String string) {
        this.m_stringLength = string.length();
        this.m_original = string;
        try {
            this.m_rawBytes = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.m_rawLength = this.m_rawBytes.length;
    }

    public int getRawLength() {
        return this.m_rawLength;
    }

    public int getPaddedLength() {
        return this.m_paddedLength;
    }

    public byte[] getPaddedBytes() {
        this.m_padBytes = 4 - this.m_rawLength % 4;
        this.m_paddedBytes = new byte[this.m_padBytes + this.m_rawLength];
        System.arraycopy(this.m_rawBytes, 0, this.m_paddedBytes, 0, this.m_rawLength);
        this.m_paddedLength = this.m_paddedBytes.length;
        return this.m_paddedBytes;
    }

    public String getPaddedHexString() {
        if (this.m_paddedBytes == null) {
            this.getPaddedBytes();
        }
        return ByteUtilities.toHexString(this.m_paddedBytes);
    }

    public String getRawHexString() {
        if (this.m_rawBytes == null) {
            return null;
        }
        return ByteUtilities.toHexString(this.m_rawBytes);
    }

    public int getNumPadBytes() {
        return this.m_padBytes;
    }

    public String toString() {
        return this.m_original;
    }
}

